// Whole-script strict mode syntax
"use strict";

var ibeCtrlMode;                     // set by parent tetfolio
var ibeCtrl_iframe_in_tetfolio_id;   // set by parent tetfolio

//Prevent scrolling
function stopScrolling(touchEvent) { touchEvent.preventDefault();   }
document.addEventListener('touchmove', stopScrolling, false);
   
// $(function() {
// 	init(calledByHozi);
//   });

function parentIsSameOrigin() {
    var result = true;
    try {
        result = window.parent.location.href !== undefined;
    } catch (e) {
        result = false;
    }
    return result;
}

function init() {
	//window.scrollTo(0, 1);//http://wordpress.org/support/topic/dont-use-windowscrollto-0-1-just-dont //The aim of this ugly thing is to remove the address bar on mobile browsers
	

	// connect to parent tetfolio -- if this is in an <iframe>

	if(window.parent === window) 
		return;
	if(!parentIsSameOrigin()) 
		return;
	var mp = $("#mainPane", window.parent.document.body);
	if(!mp.length) 
		return;

	/*
	var i=mp.find("iframe[src='"+window.location.pathname+"']");
	var el=i.parent()[0];
	//https://css-tricks.com/get-value-of-css-rotation-through-javascript/
	var st = window.getComputedStyle(el, null);
	var tr = st.getPropertyValue("-webkit-transform") ||
        st.getPropertyValue("-moz-transform") ||
        st.getPropertyValue("-ms-transform") ||
        st.getPropertyValue("-o-transform") ||
        st.getPropertyValue("transform") ||
        "";
	if(tr) {
		// With rotate(30deg)...
		// matrix(0.866025, 0.5, -0.5, 0.866025, 0px, 0px)
		//console.log('Matrix: ' + tr);

		// rotation matrix - http://en.wikipedia.org/wiki/Rotation_matrix
		
		var values = tr.split('(')[1].split(')')[0].split(',');
		var a = values[0];
		var b = values[1];
		var c = values[2];
		var d = values[3];
		
		var scale = Math.sqrt(a*a + b*b);
		
		//console.log('Scale: ' + scale);
		
		// arc sin, convert from radians to degrees, round
		var sin = b/scale;
		// next line works for 30deg but not 130deg (returns 50);
		// var angle = Math.round(Math.asin(sin) * (180/Math.PI));
		var angle = Math.round(Math.atan2(b, a) * (180/Math.PI));
		
		//console.log('Rotate: ' + angle + 'deg');

		if(scale != 1) {
			var z = 1/scale;
				$(".preload").css({
//20140611					'zoom': z,
//20140611					'ms-zoom': z,
					'-transform': 'scale('+z+')',
					'-moz-transform': 'scale('+z+')',
					'-moz-transform-origin': '0 0',
					'-ms-transform': 'scale('+z+')',
					'-ms-transform-origin': '0 0',
					'-webkit-transform': 'scale('+z+') translate3d(0,0,0)',
					'-webkit-transform-origin': '0 0'
				});
		}
	}
*/

	var tp = mp.attr("tetfoliopage");
	
	window.addEventListener("message", onIBEctrl)

}//init()


function ibeSend() {
	"use strict";

	if(!parentIsSameOrigin()) 
		return;
	
	ibeCtrlMode = window.parent && window.parent.tetroom_current && window.parent.tetroom_current() && $("[name=tetroom_ctrl_ibe]:checked", window.parent.document.body).val();
	if(ibeCtrlMode!=="active") 
		return;

	window.parent.sebSend("tetroom_action", "ibe", {
		id:ibeCtrl_iframe_in_tetfolio_id,
		hz:arguments[0],
		action: arguments[1],
		data: arguments[2]});
}

function onIBEctrl(event) {
	var parsedJSON = event.data;
	var hz = parsedJSON['hz'];
	var data = parsedJSON['data'];

	if(ibeCtrlMode==="ignore") return;

	switch(parsedJSON['action']) {
	case "button_changeFrame": 
	case "swipe_changeFrame": 
		var $hz= $('#'+hz);
		$hz.data('ibe_changeFrame').call(undefined, data);
		break;
	case "knob_changeFrame": 
		var $hz= $('#'+hz);
		$hz.IBEknob("currentStep", data, true/*prevent_socket_recursion*/);
		break;
	case "changeFrame": 
		var $hz= $('.grabble', '#'+hz);
		$hz.IBEslider("currentFrame", data, true/*prevent_socket_recursion*/);
		break;
	};
}
