(function($){
	"use strict";

	var defaults = {

	};
	function update_lines(detail, open) {
		var line1 = $('#' + detail.attr('id') + '_line1');
		var line2 = $('#' + detail.attr('id') + '_line2');

		//points

		detail.points = {
			tl: {x: detail.offset().left, y: detail.offset().top},
			tr: {x: detail.offset().left + parseInt(detail.css('width')), y: detail.offset().top},
			bl: {x: detail.offset().left, y: detail.offset().top + parseInt(detail.css('height'))},
			br: {x: detail.offset().left + parseInt(detail.css('width')), y: detail.offset().top + parseInt(detail.css('height'))},
		};

		open.points = {
			tl: {x: open.offset().left, y: open.offset().top},
			tr: {x: open.offset().left + parseInt(open.css('width')), y: open.offset().top},
			bl: {x: open.offset().left, y: open.offset().top + parseInt(open.css('height'))},
			br: {x: open.offset().left + parseInt(open.css('width')), y: open.offset().top + parseInt(open.css('height'))},
		};

		line1.points = {
			x1: detail.points.bl.x,
			y1: detail.points.bl.y,
			x2: open.points.bl.x,
			y2: open.points.bl.y
		};

		line2.points = {
			x1: detail.points.tr.x,
			y1: detail.points.tr.y,
			x2: open.points.tr.x,
			y2: open.points.tr.y
		};

		if ((open.points.tr.x - detail.points.tr.x) > 0 && (open.points.tr.y - detail.points.tr.y) > 0){
			line1.points.x1 = detail.points.tr.x;
			line1.points.y1 = detail.points.tr.y;
			line1.points.x2 = open.points.tr.x;
			line1.points.y2 = open.points.tr.y;

			if ((open.points.bl.y - detail.points.bl.y) > 0){
				line2.points.x1 = detail.points.bl.x;
				line2.points.y1 = detail.points.bl.y;
				line2.points.x2 = open.points.bl.x;
				line2.points.y2 = open.points.bl.y;
			}
			else{
				line2.points.x1 = detail.points.br.x;
				line2.points.y1 = detail.points.br.y;
				line2.points.x2 = open.points.br.x;
				line2.points.y2 = open.points.br.y;
			}
		}
		else if ((open.points.tl.x - detail.points.tl.x) > 0 && (detail.points.tr.y - open.points.tr.y) > 0){
			line1.points.x1 = detail.points.tl.x;
			line1.points.y1 = detail.points.tl.y;
			line1.points.x2 = open.points.tl.x;
			line1.points.y2 = open.points.tl.y;

			if ((open.points.br.x - detail.points.tr.x) > 0){
				line2.points.x1 = detail.points.br.x;
				line2.points.y1 = detail.points.br.y;
				line2.points.x2 = open.points.br.x;
				line2.points.y2 = open.points.br.y;
			}
			else{
				line2.points.x1 = detail.points.tr.x;
				line2.points.y1 = detail.points.tr.y;
				line2.points.x2 = open.points.tr.x;
				line2.points.y2 = open.points.tr.y;
			}
		}

		else if ((open.points.tl.x - detail.points.tl.x) < 0 && (detail.points.tr.y - open.points.br.y) > 0){
			line1.points.x1 = detail.points.bl.x;
			line1.points.y1 = detail.points.bl.y;
			line1.points.x2 = open.points.bl.x;
			line1.points.y2 = open.points.bl.y;

			line2.points.x1 = detail.points.tr.x;
			line2.points.y1 = detail.points.tr.y;
			line2.points.x2 = open.points.tr.x;
			line2.points.y2 = open.points.tr.y;
		}

		else if ((open.points.tr.x - detail.points.tr.x) < 0 && (open.points.br.y - detail.points.br.y) > 0){
			line1.points.x1 = detail.points.br.x;
			line1.points.y1 = detail.points.br.y;
			line1.points.x2 = open.points.br.x;
			line1.points.y2 = open.points.br.y;
			if ((open.points.tl.x - detail.points.tl.x) < 0){
				line2.points.x1 = detail.points.tl.x;
				line2.points.y1 = detail.points.tl.y;
				line2.points.x2 = open.points.tl.x;
				line2.points.y2 = open.points.tl.y;
			}
			else{
				line2.points.x1 = detail.points.bl.x;
				line2.points.y1 = detail.points.bl.y;
				line2.points.x2 = open.points.bl.x;
				line2.points.y2 = open.points.bl.y;
			}
		}

		else if ((open.points.tr.x - detail.points.tr.x) < 0 && (open.points.br.y - detail.points.br.y) > 0){
			line1.points.x1 = detail.points.br.x;
			line1.points.y1 = detail.points.br.y;
			line1.points.x2 = open.points.br.x;
			line1.points.y2 = open.points.br.y;

			line2.points.x1 = 0;
			line2.points.y1 = 0;
			line2.points.x2 = 0;
			line2.points.y2 = 0;
		}

		else if ((open.points.tr.x - detail.points.tr.x) < 0 && (open.points.br.y - detail.points.br.y) < 0){
			line1.points.x1 = detail.points.bl.x;
			line1.points.y1 = detail.points.bl.y;
			line1.points.x2 = open.points.bl.x;
			line1.points.y2 = open.points.bl.y;
			if ((open.points.tr.y - detail.points.tr.y) < 0){
				line2.points.x1 = detail.points.tr.x;
				line2.points.y1 = detail.points.tr.y;
				line2.points.x2 = open.points.tr.x;
				line2.points.y2 = open.points.tr.y;
			}
			else
			{
				line2.points.x1 = detail.points.tl.x;
				line2.points.y1 = detail.points.tl.y;
				line2.points.x2 = open.points.tl.x;
				line2.points.y2 = open.points.tl.y;
			}
		}

		else{
			line1.points.x1 = 0;
			line1.points.y1 = 0;
			line1.points.x2 = 0;
			line1.points.y2 = 0;

			line2.points.x1 = 0;
			line2.points.y1 = 0;
			line2.points.x2 = 0;
			line2.points.y2 = 0;
		}

		line1.attr('x1',line1.points.x1);
		line1.attr('y1',line1.points.y1);
		line1.attr('x2',line1.points.x2);
		line1.attr('y2',line1.points.y2);

		line2.attr('x1',line2.points.x1);
		line2.attr('y1',line2.points.y1);
		line2.attr('x2',line2.points.x2);
		line2.attr('y2',line2.points.y2);
	}

	var methods = {
		init : function( options ){
			/*
				settings:
					target: "$target"

				options:
					draggable: true/false
					closeable: true/false

			*/
			var detail = this;
			detail.addClass('IBEdetail')
			// currentSettings = $.extend(currentSettings, options);
			// function persistent0r() {
			// 		if(typeof $(this).data("IBEdetail") !== "undefined")
			// 		{
			// 			if(typeof(currentSettings)!=="undefined")
			// 			{
			// 				for (key in currentSettings)
			// 				{
			// 					$(this).data("IBEdetail").settings[key]=currentSettings[key];
			// 				}

			// 			}
			// 		}
			// 	}

			var data = $.extend({}, defaults, options);
			detail.data('IBEdetail', data);

			detail.css({
				border: '1px solid rgba(255, 255, 255, 0.3)',
				margin: '-1px'
			});
			
			var $target = data.target;
			if($target && $target.length) {
				$target.css({
					border: '1px solid rgba(255, 255, 255, 0)', //seb 20151116 0.3)',
					margin: '-1px'
				});
				//add SVG
				var svgObj = $('<svg id="svg_' + detail.attr('id') + '" style = "pointer-events:none; width: 100%; height: 100%; top: 0px; left:0px; z-index:2; position: absolute; stroke: white; stroke-width:1; opacity:0.3"><line id="'
							   + detail.attr('id') +'_line1" x1="0" y1="0" x2="0" y2="0""/><line id="'
							   + detail.attr('id') +'_line2" x1="0" y1="0" x2="0" y2="0"/></svg>')
					.appendTo(detail.parent());
				
				update_lines(detail, data.target);
				
				$target.click(function(){

					if(!detail.is(':visible')) { // show()
						detail.show(); // show BEFORE update_lines !! otherwise 'update_lines' doesn't work
						update_lines(detail, $target);
						svgObj.show();
						$target.css({
							//seb						'z-index': '0',
							border: '1px solid rgba(255, 255, 255, 0.3)'
						});
					} else {
						detail.hide();
						svgObj.hide();
						$target.css({
							//seb						'z-index': '0',
							border: '1px solid rgba(255, 255, 255, 0)'
						});
					}
				});
				if(data.closeable) {
					var close_id = "close_" + detail.attr('id');
					var move_id = "move_" + detail.attr('id');
					var closeDiv = $('<div id="' + close_id + '" style="position: absolute; left: -15px; top: -15px; z-index: 5;"><img src="/img/icons/button_close.png" draggable=false></div>')
						.appendTo(detail)
						.click(function(){
							detail.hide();
							svgObj.hide();
							$target.css({
//seb								'z-index': '5',
								border: '1px solid rgba(255, 255, 255, 0)'
							});
						});
						var moveHandle = $('<div id="' + move_id + '" class="moveDetail" style="position: absolute; right: -15px; top: -15px; z-index: 5;"><img src="/img/icons/button_move.png" draggable=false></div>')
						.appendTo(detail);
					svgObj.hide();
					detail.hide(); // seb note: detail===this
				}
			}
			
			if(data.draggable) {
				// detail.data("IBEdetail").settings.draggable=data.draggable;
				detail.draggable({
					drag: function on_drag() {
//seb						$('.IBEdetail').css('z-index', 4)
//seb						$(this).css('z-index', 5);
						update_lines( $(this), data.target);
					},
					handle: moveHandle,
					stop: function on_stop() {
						update_lines( $(this), data.target);
					}
				});
			}

			//seb 20151116			closeDiv.click();
			//			persistent0r();
			return detail;
		},
		update_lines: function() {
			var data = this.data('IBEdetail');
			update_lines(this, data.target);
		}
	}
	

	$.fn.IBEdetail = function( method ) {
		if ( methods[method] ) {
			return methods[method].apply( this, Array.prototype.slice.call( arguments, 1 ));
		} else if ( typeof method === 'object' || ! method ) {
			return methods.init.apply( this, arguments );
		} else {
			$.error( 'Method ' +  method + ' does not exist on jQuery.IBEdetail' );
		}
  };


	// ///////////////////////////////////////////////////////////////////////////
	// ///////////////////////////////////////////////////////////////////////////
	// ///////////////////////////////////////////////////////////////////////////


	function createDetailView($target, $HZs) {
		"use strict";

		// create DetailContainer
		var $detailContainer = $('<div id="'+$target.attr("id")+'Container"/>')
			.hide()
  			.css({
				"position": "absolute",
				"top": $HZs.eq(0).css('top'),
				"left": $HZs.eq(0).css('left'),
				"width": $HZs.eq(0).css("width"),
				"height": $HZs.eq(0).css("height"),
				"border": "1px solid rgba(255, 255, 255, 0.3)",
//seb				"z-index":"4"
			})
			.appendTo($('#stage'));
		
// 		$target.on('click', function() {
			
// 			if (!$detailContainer.is(':visible')) {
// 				$detailContainer
// 					.show();                       // needed here ! otherwise 'update_lines' doesn't work
// 				update_lines($detailContainer, $target);
// 			}
			
// //seb			$target.css({"z-index": "500"});
// 		});	
		
		var off0=$HZs.eq(0).offset();
		
		$.each($HZs, function(index,value) {
			
			var 
			top = 0, 
			left = 0;
			if (index !== 0) {
				var off=$HZs.eq(index).offset();
				top = off.top-off0.top;
				left = off.left-off0.left;
			}
			

			
			$HZs.eq(index)
				.appendTo($detailContainer)
				.css({
					"position": "absolute",
					// "pointer-events": "none",
					top: top +"px",
					left: left +"px"
				});
			
			if($HZs.eq(index).hasClass("hzslider")) {
				
				$(".grabble", $HZs.eq(index)).on('drag', function() {
					var frame = $(".grabble", $HZs.eq(index)).data('IBEslider').settings.currentFrame;
					$target.IBEslider("currentFrame", frame);
					$detailContainer.IBEdetail('update_lines');
				});
				
				$detailContainer.on( "dragstop", function() { 
					
					$(".grabble", $HZs.eq(index))
						.IBEslider("update_containment")
				});
			}
		});
		
		
		$detailContainer
			.IBEdetail({
				draggable: true,
				closeable: true,
     			target: $target
			});
		
		if ($target.hasClass('grabble')) {
			$target.on('drag', function() {
				$detailContainer.IBEdetail('update_lines');
				
				$.each($HZs, function(index,value) {
					if($HZs.eq(index).hasClass("hzslider")) {
						var frame = $target.data('IBEslider').settings.currentFrame;
						$('.grabble', $HZs.eq(index) ).IBEslider("currentFrame", frame);
					}
				}); // end each
			});
		}
	}

	// put into global namespace
	window.createDetailView = createDetailView;
})( jQuery );
